#ifndef __jabberservicesink_h__
#define __jabberservicesink_h__

#include "csfunified/framework/UnifiedFactory.h"
#include "csfunified/services/interface/InstantMessageCommandCode.h"
#include "csfunified/services/interface/InstantMessageConversationService.h"
#include "csfunified/services/interface/InstantMessageCommandReceivedCallback.h"
#include "csfunified/services/interface/SystemService.h"
#include "csfunified/services/interface/ConfigService.h"
#include "csfunified/services/interface/ConfigValue.h"
#include "csfunified/services/interface/PresenceService.h"
#include "csfunified/services/interface/Contact.h"
#include "csfsystemmonitor/SystemMonitor.h"
#include "csf/Task.hpp"
#include "jcfcoreutils/FunctionTask.h"
#include "csfunified/framework/FunctorTask.h"
#include "csfunified/framework/ServicesDispatcher.h"
#include "boost/bind.hpp"

#include <csf/RWLock.hpp>

namespace CSFUnified
{
	class JabberServiceSink : public InstantMessageCommandReceivedCallback
	{
	public:
		static JabberServiceSink& getInstance()
		{
			static JabberServiceSink s_sink;
			return s_sink;
		}
		~JabberServiceSink();

		void start();
		void stop();

		void OnInstantMessageCommandReceived(std::string uri, std::string participantUri, InstantMessageCommandCodeEnum::InstantMessageCommandCode commandCode, std::string commandContent, std::string plaintext, std::string richtext, bool isGroupChatCmd);

		void onPresenceChange(SMART_PTR_NS::shared_ptr<CSFUnified::Contact> contact);

		//Client Event
		virtual void onSignOn();
		virtual void onSignOff();


	private:
		JabberServiceSink();
		void fireonNetworkChanged(bool bConnected);

	private:
		bool m_bNetWork_Connect;
		bool m_bStarted;

		csf::RWLock mLock;
	};
}

#endif
